#ifndef _CERT_TLK_ATP_TESTS_H_
#define _CERT_TLK_ATP_TESTS_H_

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/


#ifdef __cplusplus
extern "C"
{
#endif

  /*
  *  Object %name    : %
  *  State           :  %state%
  *  Creation date   :  17-March -07
  *  Last modified   :  %modify_time%
  */
  /** @file
  *  \brief A brief description of this module
  *
  *  \version CERT_TLK_ATP_tests.h#1:incl:1
  *  \author SagitB
  *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
  *           All Rights reserved
  */

  /*****************************************************************************
  * Function Name:                                                           
  *  TST_ATP_TLK_CERT_CertificateIdCompute
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return                                        
  *
  * Description:                                                                 
  *    Test TLK_CERT_CertificateIdCompute
  *  
  * Algorithm: 
  * 1.	Call the API. TLK_CERT_CertificateIdCompute.
  * 2.	Compare the out value of certificateId_ptr with the calculated certificate identifier generated in advance. 
  *******************************************************************************/   
  DxError_t TST_ATP_TLK_CERT_CertificateIdCompute(void);

  
  /*****************************************************************************
  * Function Name:                                                           
  *  TST_ATP_TLK_CERT_CertificateParamGety
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return                                        
  *
  * Description:                                                                 
  *    Test TLK_CERT_CertificateParamGet
  *  
  * 1.Call the API. TLK_CERT_CertificateParamGet.
  * 2.Compare the out value of certificateParamList_ptr with the calculated certificate TLK_CERT_CertProcessParameters_t
  * that was with inputs from the certificate in advance.
  *******************************************************************************/   
  DxError_t TST_ATP_TLK_CERT_CertificateParamGet(void);
  
  /*****************************************************************************
  * Function Name:                                                           
  *  TST_ATP_TLK_CERT_CertificateChainValidation
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return                                        
  *
  * Description:                                                                 
  *    Test TLK_CERT_ChainValidationInit, TLK_CERT_ChainValidationProcess and TLK_CERT_ChainValidationTerminate
  *  
  * Algorithm: 
  *1.	Call TLK_CERT_ChainValidationInit.
  * 2.	Call TLK_CERT_ChainValidProcess 3 times on the sequence of the chain every time the API will get the updated context from
  *      the previous call.
  * 3.	Initialize the SST by calling: SST_Init.
  * 4.	Create a new session by calling: SST_SessionCreate
  * 5.	Open a transaction by calling: SST_TransactionStart.
  * 6.	Insert the root certificate to the SST by calling: SST_InsertData
  * 7.	Insert the parameters from SST operations to sstAccessParams
  * 8.	Call TLK_CERT_ChainValidProcess with the parameter sstAccessParams  the root Ca. 
  * 9.	Close the transaction by calling: SST_TransactionEnd.
  * 10.	Delete the session by calling: SST_SessionDelete.
  * 11.	Terminate the SST operation by calling: SST_Terminate.
  * 12.	Call TLK_CERT_ChainValidTerminate 
  * 13.	Validate the TLK_CERT_CPVO_t have the correct fields: subjectNameTR and issuerNameTR from the trusted root certificate
  *     subjectNameEE and issuerNameEE from the first certificate in the chain are the same and all other fields equal the fields
  *		 from the certificate.    
  *******************************************************************************/  
  DxError_t TST_ATP_TLK_CERT_CertificateChainValidation(void);

 /*****************************************************************************
  * Function Name:                                                           
  *  TST_ATP_TLK_CERT_1667_CertificateChainValidation
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return                                        
  *
  * Description:                                                                 
  *    Test TLK_CERT_ChainValidationInit, TLK_CERT_ChainValidationProcess , TLK_CERT_ChainValidationTerminate and
  *  TLK_CERT_1667_WorkspaceSizeGet
  *  
  * Algorithm: 
  * 1.  TLK_CERT_1667_WorkspaceSizeGet.
  * 2.  Call TLK_CERT_1667_ChainValidationInit.
  * 3.  Call TLK_CERT_1667_ChainValidProcess with the root Ca. 
  * 4.  Call TLK_CERT_1667_ChainValidProcess 3 times on the sequence of the chain every time the API will get the updated context from
  *      the previous call.
  * 5. Call TLK_CERT_1667_ChainValidTerminate 
  * 6. Validate the TLK_CERT_1667_CPVO_t have the correct fields: subjectNameTR and issuerNameTR from the trusted root certificate
  *     subjectNameEE and issuerNameEE from the first certificate in the chain are the same and all other fields equal the fields
  *  from the certificate.    
  *******************************************************************************/ 

  DxError_t TST_ATP_TLK_CERT_1667_CertificateChainValidation();

  /*****************************************************************************
  * Function Name:                                                           
  *  TST_ATP_TLK_CERT_NonceIssuance
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return                                        
  *
  * Description:                                                                 
  *    Test TLK_CERT_NonceIssuance
  *  
  * Algorithm: 
  * 1.	Call the API  TLK_CERT_NonceIssuance
  * 2.	Verify the time stamp.

  *******************************************************************************/  

  DxError_t TST_ATP_TLK_CERT_NonceIssuance(void);

  /*****************************************************************************
  * Function Name:                                                           
  *  TST_ATP_TLK_CERT_ResponseProcess
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return                                        
  *
  * Description:                                                                 
  *    Test TLK_CERT_ResponseProcess 
  *  
  * Algorithm:
  *1. Call TLK_CERT_ResponseProcess with a valid OCSP  response a nonce a certificate to be checked and a CA certificate, 
  *   that issued the certificate to be checked
  *2. verify it returns TLK_CERT_RC_OK 
  *3. Call TLK_CERT_ResponseProcess with a valid OCSP  response a certificate to be checked and a CA certificate,
  *   that issued the certificate to be checked
  *4. Call TLK_CERT_ResponseProcess with a valid OCSP response, certificate for the OCSP responder,
  *   a certificate to be checked and a CA certificate that issued the certificate to be checked.
  *******************************************************************************/ 
DxError_t TST_ATP_TLK_CERT_ResponseProcess(void);

/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_TLK_CERT_CertFromResponseExtract
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
*    Test TLK_CERT_CertFromResponseExtract 
*  
* Algorithm:
* 1. Call TLK_CERT_CertFromResponseExtract.
* 2. Verify the filed in the certificate extracted are the same in the certificate in the response.
* 3. validate the nextUpdate field extracted is similar to the one in the certificate   

*******************************************************************************/ 

DxError_t TST_ATP_TLK_CERT_CertFromResponseExtract(void);

 

#ifdef __cplusplus
}
#endif

#endif
